/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.renderers.entities;

import com.alexander.mutantmore.entities.MutantWitherSkeleton;
import com.alexander.mutantmore.models.entities.MutantWitherSkeletonModel;
import com.alexander.mutantmore.renderers.layers.MutantWitherSkeletonFlameLayer;
import com.alexander.mutantmore.renderers.layers.MutantWitherSkeletonLavaFeetLayer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.block.state.BlockState;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.geo.render.built.GeoBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.renderers.geo.ExtendedGeoEntityRenderer;

public class MutantWitherSkeletonRenderer
extends ExtendedGeoEntityRenderer<MutantWitherSkeleton> {
    public MutantWitherSkeletonRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (AnimatedGeoModel)new MutantWitherSkeletonModel());
        this.addLayer(new MutantWitherSkeletonFlameLayer(this));
        this.addLayer(new MutantWitherSkeletonLavaFeetLayer(this));
        this.f_114477_ = 1.25f;
        this.f_114478_ = 1.0f;
    }

    protected float getDeathMaxRotation(MutantWitherSkeleton animatable) {
        return 0.0f;
    }

    protected void applyRotations(MutantWitherSkeleton entityLiving, PoseStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks) {
        float scaleFactor = 1.2f;
        matrixStackIn.m_85841_(scaleFactor, scaleFactor, scaleFactor);
        super.applyRotations((LivingEntity)entityLiving, matrixStackIn, ageInTicks, rotationYaw, partialTicks);
    }

    protected ItemStack getHeldItemForBone(String boneName, MutantWitherSkeleton currentEntity) {
        switch (boneName) {
            case "bipedHandLeft": {
                return currentEntity.m_21526_() ? this.mainHand : this.offHand;
            }
            case "bipedHandRight": {
                return currentEntity.m_21526_() ? this.offHand : this.mainHand;
            }
        }
        return null;
    }

    protected ItemTransforms.TransformType getCameraTransformForItemAtBone(ItemStack boneItem, String boneName) {
        switch (boneName) {
            case "bipedHandLeft": {
                return ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND;
            }
            case "bipedHandRight": {
                return ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND;
            }
        }
        return ItemTransforms.TransformType.NONE;
    }

    protected void preRenderItem(PoseStack stack, ItemStack item, String boneName, MutantWitherSkeleton currentEntity, IBone bone) {
        if (item == this.mainHand || item == this.offHand) {
            stack.m_85841_(1.1f, 1.1f, 1.1f);
            stack.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
            boolean shieldFlag = item.m_41720_() instanceof ShieldItem;
            if (item == this.mainHand) {
                if (shieldFlag) {
                    stack.m_85837_(0.0, 0.125, -0.25);
                }
            } else if (shieldFlag) {
                stack.m_85837_(0.0, 0.125, 0.25);
                stack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
            }
        }
    }

    protected void postRenderItem(PoseStack matrixStack, ItemStack item, String boneName, MutantWitherSkeleton currentEntity, IBone bone) {
    }

    protected ItemStack getArmorForBone(String boneName, MutantWitherSkeleton currentEntity) {
        switch (boneName) {
            case "armorLeftFoot": 
            case "armorRightFoot": {
                return this.boots;
            }
            case "armorLeftLeg": 
            case "armorRightLeg": 
            case "armorLeftLegLower": 
            case "armorRightLegLower": {
                return this.leggings;
            }
            case "armorBody": 
            case "armorRightArm": 
            case "armorLeftArm": {
                return this.chestplate;
            }
            case "armorHead": {
                return this.helmet;
            }
        }
        return null;
    }

    protected EquipmentSlot getEquipmentSlotForArmorBone(String boneName, MutantWitherSkeleton currentEntity) {
        switch (boneName) {
            case "armorLeftFoot": 
            case "armorRightFoot": {
                return EquipmentSlot.FEET;
            }
            case "armorLeftLeg": 
            case "armorRightLeg": 
            case "armorLeftLegLower": 
            case "armorRightLegLower": {
                return EquipmentSlot.LEGS;
            }
            case "armorRightArm": {
                return !currentEntity.m_21526_() ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
            }
            case "armorLeftArm": {
                return currentEntity.m_21526_() ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
            }
            case "armorBody": {
                return EquipmentSlot.CHEST;
            }
            case "armorHead": {
                return EquipmentSlot.HEAD;
            }
        }
        return null;
    }

    protected ModelPart getArmorPartForBone(String name, HumanoidModel<?> armorModel) {
        switch (name) {
            case "armorLeftFoot": 
            case "armorLeftLeg": 
            case "armorLeftLegLower": {
                return armorModel.f_102814_;
            }
            case "armorRightFoot": 
            case "armorRightLeg": 
            case "armorRightLegLower": {
                return armorModel.f_102813_;
            }
            case "armorRightArm": {
                return armorModel.f_102811_;
            }
            case "armorLeftArm": {
                return armorModel.f_102812_;
            }
            case "armorBody": {
                return armorModel.f_102810_;
            }
            case "armorHead": {
                return armorModel.f_102808_;
            }
        }
        return null;
    }

    protected BlockState getHeldBlockForBone(String boneName, MutantWitherSkeleton currentEntity) {
        return null;
    }

    protected void preRenderBlock(PoseStack matrixStack, BlockState block, String boneName, MutantWitherSkeleton currentEntity) {
    }

    protected void postRenderBlock(PoseStack matrixStack, BlockState block, String boneName, MutantWitherSkeleton currentEntity) {
    }

    protected ResourceLocation getTextureForBone(String boneName, MutantWitherSkeleton currentEntity) {
        switch (boneName) {
            default: 
        }
        return null;
    }

    protected boolean isArmorBone(GeoBone bone) {
        return bone.getName().startsWith("armor");
    }

    public RenderType getRenderType(MutantWitherSkeleton animatable, float partialTicks, PoseStack stack, MultiBufferSource renderTypeBuffer, VertexConsumer vertexBuilder, int packedLightIn, ResourceLocation textureLocation) {
        return RenderType.m_110473_((ResourceLocation)textureLocation);
    }
}

